# for PYTHON 3+ with pySerial module installed
# DS INSTRUMENTS 2017 PYTHON SCPI REMOTE CONTROL EXAMPLE
import serial   # use the serial module (https://pypi.python.org/pypi/pyserial)
import time     # delay functions
badCommandResponse = b'[BADCOMMAND]\r\n'    # response if a command failed (b makes it into bytes)

ser = serial.Serial("COM79", 115200, timeout=1) #Change the COM PORT NUMBER to match your device
if ser.isOpen():    # make sure port is open
    print(ser.name + ' open...')    # tell the user we are starting
	
    ser.write(b'*IDN?\n')   # send the standard SCPI identify command
    myResponse = ser.readline()    # read the response
    print(b'Device Info: ' + myResponse) # print the unit information
	
    time.sleep(0.1)    # delay 100ms
    ser.write(b'PHASE?\n')       # try asking for phase
    myResponse = ser.readline() # gather the response
    if myResponse != badCommandResponse:    #is this is not a phase shifter why print the error
        print(b'Phase=' +myResponse)
		
    time.sleep(0.1)  # delay 100ms
    ser.write(b'FREQ:CW?\n')  # try asking for signal generator setting
    myResponse = ser.readline()  # gather the response
    if myResponse != badCommandResponse:  # is this is not a signal generator why print the error
        print(b'Frequency=' + myResponse)
		
    time.sleep(0.1)  # delay 100ms
    ser.write(b'ATT?\n')  # try asking for step attenuator setting
    myResponse = ser.readline()  # gather the response
    if myResponse != badCommandResponse:  # is this is not an attenuator why print the error
        print(b'Attenuation=' + myResponse)
		
    time.sleep(0.1)  # delay 100ms
    ser.write(b'FREQ:CW 3GHZ\n')  #lets change a setting now!