﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;




namespace SigGenV1 {
    public partial class Form1 : Form {
        SerialPort connectedPort = null;






        public Form1() {
            InitializeComponent();
            getPorts();
        }






		private bool isConnected() {
			if (connectedPort != null) {
				return true;
			}
			return false;
		}






        private void sendCommand(string myCommand) {
			if (isConnected()) {    // only try to write if we know the port is open
                //printResponseNow("TX: " + myCommand);
                connectedPort.WriteLine(myCommand);
			}
        }





   
        // find ports and put into a box
        private void getPorts() {
            COMselectBox.Items.Clear();
            COMselectBox.Text = "";
            COMselectBox.BackColor = Color.Empty;
            string[] ports = SerialPort.GetPortNames(); // get all the current installed ports

            // fill the select box from the array
            for (int i = 0; i < ports.Length; i++) {
                COMselectBox.Items.Add(ports[i].ToString());
            }
            // auto select port if only 1 is listed
            if (ports.Length == 1) {
                COMselectBox.SelectedIndex = 0;
            }
        }









        private SerialPort testPort(string portName) {
            SerialPort testPort = new SerialPort(portName, 115200, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One);   // declare and populate a new serial port object
            if (!testPort.IsOpen) { // make sure we are not using this one already
                try {
                    testPort.Open();    // real work !
                    testPort.WriteLine("*PING?");   // Send out a test command
                    testPort.ReadTimeout = 500;
                    string myResponse = testPort.ReadLine();

                    if (!myResponse.Equals("PONG!\r")) {    // look for the standard response
                        testPort.Close();   // things failed so close this port
                        testPort = null;
                    }
                }
                catch (Exception e1) {
                    printResponseNow(e1.Message);
                    testPort = null;
                }
            }
            return testPort;
        }








        private string getMyResponse() {
            string rawResponse = "";
            try {
                if (isConnected()) {
                    rawResponse = connectedPort.ReadLine();
                    if (rawResponse.Length > 1) {
                        if (rawResponse.EndsWith("\r")) {
                            rawResponse = rawResponse.Substring(0, rawResponse.Length - 1); // crop off that invisible character
                        }
                    }
                    printResponseNow(rawResponse);
                }
            } catch (Exception e1) {
                printResponseNow(e1.Message);
                killPort();
            }
            return rawResponse;
        }







        // add the newest response to our display box
        private void printResponseNow(string myMessage) {
            textBoxResponse.Text = myMessage + "\r\n" + textBoxResponse.Text;
        }



        





        // START COMS STUFF HERE
        private void COMbutton_Click(object sender, EventArgs e) {
            killPort();
            if (COMselectBox.Text.Length > 0) {     // something is in the COM select box
                connectedPort = testPort(COMselectBox.SelectedItem.ToString());
                COMselectBox.BackColor = Color.LightGreen;
                if (!isConnected()) {
                    killPort();
                }
            }
        }






        // we must actually close ports cleanly!
        private void killPort() {
            COMselectBox.BackColor = Color.Salmon;
            if (connectedPort != null) {
                connectedPort.Close();
                connectedPort.Dispose();
                connectedPort = null;
            }
        }



        



        


        // if we mess with the COM select box we will close teh port that might have been open
        private void COMselectBox_SelectedIndexChanged(object sender, EventArgs e) {
            killPort();
        }



        





        // reload button will close the current port if open and request the list of system com ports
        private void buttonReload_Click(object sender, EventArgs e) {
            killPort();
            getPorts();
        }






        private void buttonSendCom_Click(object sender, EventArgs e) {
            string myCommand = comboBoxCommand.Text;
            if (myCommand.Length > 0 && myCommand.Length < 64) {
                sendCommand(myCommand);
                comboBoxCommand.Text = "";  // clear the input box
                
                try {
                    string possibleResponse = connectedPort.ReadLine();
                    printResponseNow(possibleResponse);
                } catch (Exception e1) {
                    // many commands DO NOT HAVE A RESPONSE, so this is not really an error here
                    printResponseNow("NO RESPONSE. (" + e1.Message + ")");
                }

            }
        }









    }
}
